//********************************************************************;
//*                                                                  *;
//*  Intel(R) Confidential                                           *;
//*                                                                  *;
//*  TXTINFO64   Tool                                                *;
//*                                                                  *;
//*  Copyright (c) 2009 Intel Corp.                                  *;
//*                                                                  *;
//*  This code has been developed by Intel Corporation.              *;
//*  Licensee has Intel's permission to incorporate this source code *;
//*  into their product, royalty free.  This source code may NOT be  *;
//*  redistributed to anyone without Intel's written permission.     *;
//*                                                                  *;
//*  Intel specifically disclaims all warranties, express or         *;
//*  implied, and all liability, including consequential and other   *;
//*  indirect damages, for the use of this code, including liability *;
//*  for infringement of any proprietary rights, and including the   *;
//*  warranties of merchantability and fitness for a particular      *;
//*  purpose.  Intel does not assume any responsibility for any      *;
//*  errors which may appear in this code nor any responsibility to  *;
//*  update it.                                                      *;
//*                                                                  *;
//********************************************************************;

#include "Uefi.h"
#include "Uefilib.h"
#include "ShellLib.h"
#include "BaseMemoryLib.h"
#include "MemoryAllocationLib.h" //For AllocateZeroPool
#include <DebugLib.h>
#include <ShellCEntryLib.h>

#include "TPM20Info.h"
#include "TPM20UI.h"
#include "ServerTPM2Tool.h"
#include "TpmTIS.h"
//#include "stdio.h"
//#include "stdlib.h"
//#include "string.h"

extern EFI_BOOT_SERVICES  *gBS;
EFI_SYSTEM_TABLE   *gST;


INTN EFIAPI ShellAppMain(IN UINTN Argc, IN CHAR16** Argv)
//int main(IN UINTN Argc, IN CHAR16** Argv) 
//EFI_STATUS EFIAPI ServerTPMToolMain (IN EFI_HANDLE ImageHandle, IN EFI_SYSTEM_TABLE  *SystemTable )
{
	//date
	CHAR16		*szDebugApp = L"DEBUG";
	CHAR16		*szAppType = L"x64";
	CHAR16 		ch16DATE[20];
	
	//tokenizing
	UINT32 		i = 0;
	CHAR16		*token = NULL; 

	OPTIONAL_ARGUMENTS optionalArgs;
	CHAR16		*args[8];
	UINT32 		numArgs;

	UINT32 errorCode = 0;
	AsciiStrToUnicodeStr(__DATE__,ch16DATE);

	Print(L"\nIntel(R) TPM Tool %s %s. Major version:[%s] Minor version:[%s] BUILD DATE:[%s].\n",
		szAppType,
		szDebugApp,
		TPM_FACT_PROV_TOOL_MAJOR_VERSION,
		TPM_FACT_PROV_TOOL_MINOR_VERSION,
		/*__DATE__*/ch16DATE
		);
	
	if ( Argc > 1) {
	
    if (LocateTrEEProtocol() != 0) {
      setActiveLocality0();
      nextStateTransition();
    }
		//TPM_20_Startup( TPM_SU_CLEAR ); 
		
		optionalArgs.verboseLevel = 1;
		optionalArgs.responseFile = FALSE;
		optionalArgs.responseFileAppend = FALSE;
		//Print(L"Argc: %d\n", Argc);
		if ( Argc > 8 ) {
			Print(L"Too many arguments\n");
			return -1;
		}
		
		for (i = 1; i < Argc; i++) {
			//Print(L"Argv[i]: %s\n", Argv[i]);
			//Print(L"StrLen(Argv[i]): %d\n", StrLen(Argv[i]));
			
			args[i-1] = AllocateZeroPool( 256 );
			StrnCpy(args[i-1], Argv[i], StrLen(Argv[i]) );
			//Print(L"arg %d: %s\n", i, args[i-1] );
		}
		
		for (i = 0; i < Argc - 1; i++) {
		
			/*
			if( StrCmp(args[i], L"-v") == 0 ) {
				UINT64 			u64offset;
				//tokenise the verbose level
				token = mystrtok(Argv[i], L"v");
				token = mystrtok(NULL, L"v");
				
				ShellConvertStringToUint64( token, &u64offset, TRUE, TRUE );
				optionalArgs.verboseLevel = (UINT32) u64offset;
			}
			
			
			if( StrCmp(args[i], L"-rf") == 0 ) {
				optionalArgs.responseFile = TRUE;
			}
			
			
			if( StrCmp(args[i], L"-rf+") == 0 ) {
				optionalArgs.responseFileAppend = TRUE;
				
			}
			*/
			if( StrCmp(args[i], L"-h") == 0 ) {
				help();
				Exit();
			}
			
			
		}
		
		//Print(L"Error level: %d\n", optionalArgs.verboseLevel);
		//Print(L"responseFile: %d\n", optionalArgs.responseFile);
		//Print(L"responseFileAppend: %d\n", optionalArgs.responseFileAppend);
		
		//errorCode = tpmOperation(args, &optionalArgs);
		errorCode = tpmOperation(args, Argc - 1, &optionalArgs);
		
		//return 0;
		
	} else {
		Print(L"Not enough arguments\n");
	}
	Print(L"errorCode: %d\n", errorCode);
	return errorCode;
}


void help()
{

	Print(L"TPM 2.0 Prov Tool Commands\n");

	Print(L"StartSession <SessionDefFile.sDef> <Session #>\n");

	Print(L"FlushSession <Session #>\n");

	Print(L"PolicyRestart <Session #>\n");

	Print(L"NvDefineSpace <IndexDefFile.iDef> <Session #>\n");

	Print(L"NvWrite <IndexDefFile.iDef> <Session #>\n");

	Print(L"NvVerifyDef <IndexDefFile.iDef> \n");

	Print(L"NvCompareData <IndexDefFile.iDef> \n");

	Print(L"NvReadPublic <IndexDefFile.iDef> \n");

	Print(L"NvRead <IndexDefFile.iDef> \n");

	Print(L"UndefineSpace <IndexDefFile.iDef> <Session #>\n");

	Print(L"UndefineSpecial <IndexDefFile.iDef> <Current Session #>  <Session # AuthArea>\n");

	Print(L"AssertPolicy <PolicyDefFile.pDef> <Session #>\n");

	Print(L"SetPolDigest <RawDataFile.dat> <# bytes from file> <cfg AuthLocation #>\n");

	Print(L"StorePolDigest <DigestListFile.dlf> <Session #> <DLF index>\n");

	Print(L"SetPrimaryPolicy <PolicyFile.pSet> <Session #> \n");

	Print(L"HierarchyChangeAuth <Session #>\n");

	Print(L"NVChangeAuth <IndexDefFile.iDef> <Session #> <CFG_Auth #>\n");

	Print(L"HashStart <Handle #>\n");

	Print(L"HashUpdate <Handle #> <DataFilename> <DataSize>\n");

	Print(L"HashComplete < Handle #>\n");

	Print(L"NVWriteLock <IndexdefFile.iDef>  <Session #>\n");

	Print(L"GetRandom <dataSize> <outputFilename> \n");

	Print(L"CreatePrimary <KeyDef.kDef> <session#> <output handle number> <Key OutPublic Filename.dat>\n");

	Print(L"Create <KeyDef.kDef> <session#> <input handle number> <Key OutPrivate Filename.dat> <Key OutPublic Filename.dat>\n");

	Print(L"LoadExternal <KeyFilename.pub> \n");

	Print(L"Load <keyPrivate.prv> <keyPublic.pub>\n");

	Print(L"StartUp\n");

	Print(L"Note: use session 0 for policy sessions, session 1 for password sessions, and session 3 for key creation.\n");

}